<?php
// Usuarios/registrodeUsuarios.php
session_start();
require '../config.php';
$msg = $_SESSION['msg'] ?? '';
unset($_SESSION['msg']);



$nomeLogado = $_SESSION['user_nome'] ?? 'Usuário';

$erro = '';
$msg  = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nome  = trim($_POST['nome'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $senha = $_POST['senha'] ?? '';

    if ($nome === '' || $email === '' || $senha === '') {
        $erro = 'Preencha todos os campos.';
    } else {
        $hash = password_hash($senha, PASSWORD_DEFAULT); // hash seguro[web:64]

        $stmt = $mysqli->prepare(
            'INSERT INTO users (nome, email, senha_hash) VALUES (?, ?, ?)'
        );
        $stmt->bind_param('sss', $nome, $email, $hash);

        if ($stmt->execute()) {
            $msg = 'Usuário cadastrado com sucesso.';
        } else {
            $erro = 'Erro ao cadastrar (talvez email já exista).';
        }
        $stmt->close();
    }
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <link rel="stylesheet" href="./usuarios.css">
    <title>Usuários</title>
</head>
<body>

<?php include '../Sidebar/sidebar.php'; ?>

<div class="main">
    <div class="topbar">
        <div><h1>Gerenciamento de Usuários</h1></div>
        <div class="topbar-right">
            <span><?= htmlspecialchars($nomeLogado) ?></span>
            <div class="avatar"></div>
        </div>
    </div>

    <div class="content">

        <div class="table-wrapper">
            <div class="table-title">Novo usuário</div>

            <?php if ($msg): ?>
                <p><?= htmlspecialchars($msg) ?></p>
            <?php endif; ?>

            <form method="post" action="">
                <table>
                    <tr>
                        <td><label for="nome">Nome</label></td>
                        <td>
                            <input id="nome" type="text" name="nome" placeholder="Nome completo">
                        </td>
                    </tr>
                    <tr>
                        <td><label for="email">Email</label></td>
                        <td>
                            <input id="email" type="email" name="email" placeholder="Email">
                        </td>
                    </tr>
                    <tr>
                        <td><label for="senha">Senha</label></td>
                        <td>
                            <input id="senha" type="password" name="senha" placeholder="Senha">
                        </td>
                    </tr>
                    <tr>
                        <td></td>
                        <td>
                           <button type="submit">Registrar</button>
                           <?php if (!empty($erro)): ?>
                                <p class="error-msg"><?= htmlspecialchars($erro) ?></p>
                            <?php endif; ?>
                        </td>
                    </tr>
                </table>
            </form>
        </div>

        <?php include 'listagemTodosUsuarios.php'; ?>

    </div>
</div>

</body>
</html>
