<?php
// Usuarios/excluirUsuarios.php
session_start();
require '../config.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: registrodeUsuarios.php');
    exit;
}

$id = isset($_POST['id']) ? (int)$_POST['id'] : 0;

if ($id <= 0) {
    $_SESSION['msg'] = 'ID de usuário inválido.';
    header('Location: registrodeUsuarios.php');
    exit;
}

$stmt = $mysqli->prepare('DELETE FROM users WHERE id = ?');
$stmt->bind_param('i', $id);

if ($stmt->execute()) {
    $_SESSION['msg'] = 'Usuário excluído com sucesso.';
} else {
    $_SESSION['msg'] = 'Erro ao excluir usuário.';
}

$stmt->close();

header('Location: registrodeUsuarios.php');
exit;
